
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
paul = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul")
bill = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")
laura = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura")
mary = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary")
jean = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean")
george = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george")
john = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john")


# Set objective function
m.setObjective(4*paul + 6*bill + 1*laura + 3*mary + 3*jean + 2*george + 3*john, gp.GRB.MINIMIZE)

# Add constraints

m.addConstr(6 * laura + 3 * jean >= 86)
m.addConstr(28 * george + 26 * john >= 40)
# ... (add all other constraints similarly)

#Resource constraints
r = {}
r[0] = {'ub': 738, 'vars': [23, 11, 6, 2, 3, 28, 26]}
r[1] = {'ub': 728, 'vars': [2, 13, 22, 24, 16, 4, 10]}
r[2] = {'ub': 660, 'vars': [23, 15, 28, 10, 11, 6, 20]}
r[3] = {'ub': 391, 'vars': [21, 26, 20, 29, 21, 1, 16]}

vars = [paul, bill, laura, mary, jean, george, john]

for i in range(4):
    m.addConstr(sum(r[i]['vars'][j] * vars[j] for j in range(7)) <= r[i]['ub'])


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

