
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=-gp.GRB.INFINITY)  # hours worked by Paul
x1 = m.addVar(name="x1", lb=-gp.GRB.INFINITY)  # hours worked by Bill
x2 = m.addVar(name="x2", lb=-gp.GRB.INFINITY)  # hours worked by Laura
x3 = m.addVar(name="x3", lb=-gp.GRB.INFINITY)  # hours worked by Mary
x4 = m.addVar(name="x4", lb=-gp.GRB.INFINITY)  # hours worked by Jean
x5 = m.addVar(name="x5", lb=-gp.GRB.INFINITY)  # hours worked by George
x6 = m.addVar(name="x6", lb=-gp.GRB.INFINITY)  # hours worked by John

# Objective function
m.setObjective(4*x0 + 6*x1 + x2 + 3*x3 + 3*x4 + 2*x5 + 3*x6, gp.GRB.MINIMIZE)

# Constraints
# Omitted for brevity, as there are many constraints

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Paul: ", x0.varValue)
    print("Hours worked by Bill: ", x1.varValue)
    print("Hours worked by Laura: ", x2.varValue)
    print("Hours worked by Mary: ", x3.varValue)
    print("Hours worked by Jean: ", x4.varValue)
    print("Hours worked by George: ", x5.varValue)
    print("Hours worked by John: ", x6.varValue)
else:
    print("The model is infeasible")
