
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")
vitamin_b7 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")
carbohydrates = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="carbohydrates")

# Set objective function
m.setObjective(8 * vitamin_c + 3 * vitamin_b7 + 9 * carbohydrates, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * vitamin_c + 23 * vitamin_b7 <= 58, "muscle_growth_c_b7")
m.addConstr(10 * vitamin_c + 10 * carbohydrates <= 99, "muscle_growth_c_carb")
m.addConstr(10 * vitamin_c + 23 * vitamin_b7 + 10 * carbohydrates <= 99, "muscle_growth_total")


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vitamin_c:', vitamin_c.x)
    print('vitamin_b7:', vitamin_b7.x)
    print('carbohydrates:', carbohydrates.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

