
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(name="vitamin_c", lb=0)  # Milligrams of vitamin C
x2 = m.addVar(name="vitamin_b7", lb=0)  # Milligrams of vitamin B7
x3 = m.addVar(name="carbohydrates", lb=0)  # Grams of carbohydrates

# Define the objective function
m.setObjective(8*x1 + 3*x2 + 9*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 23*x2 <= 58, name="constraint_1")
m.addConstr(10*x1 + 10*x3 <= 99, name="constraint_2")
m.addConstr(10*x1 + 23*x2 + 10*x3 <= 99, name="constraint_3")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Vitamin C: {x1.x}, Vitamin B7: {x2.x}, Carbohydrates: {x3.x}")
else:
    print("No optimal solution found.")

