
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams_of_vitamin_C", lb=0)
    x2 = model.addVar(name="milligrams_of_vitamin_B7", lb=0)
    x3 = model.addVar(name="grams_of_carbohydrates", lb=0)

    # Define the objective function
    model.setObjective(8*x1 + 3*x2 + 9*x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(10*x1 + 23*x2 <= 58, name="vitamin_C_B7_constraint")
    model.addConstr(10*x1 + 10*x3 <= 99, name="vitamin_C_carbohydrates_constraint")
    model.addConstr(10*x1 + 23*x2 + 10*x3 <= 99, name="all_variables_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin C: {x1.varValue}")
        print(f"Milligrams of vitamin B7: {x2.varValue}")
        print(f"Grams of carbohydrates: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
