
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
hot_dogs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hot_dogs")
ham_sandwiches = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ham_sandwiches")
oreos = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")
chicken_drumsticks = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_drumsticks")
bananas = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bananas")


# Set objective function
m.setObjective(3*hot_dogs + 2*ham_sandwiches + 7*oreos + 3*chicken_drumsticks + 6*bananas, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(18*hot_dogs + 10*ham_sandwiches + 3*oreos + 22*chicken_drumsticks + 17*bananas <= 436, "c0")
m.addConstr(15*hot_dogs + 13*ham_sandwiches + 19*oreos + 12*chicken_drumsticks + 21*bananas <= 142, "c1")
m.addConstr(9*hot_dogs + 15*ham_sandwiches + 10*oreos + 6*chicken_drumsticks + 3*bananas <= 239, "c2")

# ... (rest of the constraints from the JSON "constraints" section)

m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

