
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
oreos = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")
bowls_of_pasta = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bowls_of_pasta")
kale_salads = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="kale_salads")
ham_sandwiches = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="ham_sandwiches")
pickles = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="pickles")


# Set objective function
m.setObjective(2.29*oreos**2 + 5.26*oreos*bowls_of_pasta + 2.95*oreos*ham_sandwiches + 5.47*bowls_of_pasta**2 + 9.05*bowls_of_pasta*kale_salads + 3.65*ham_sandwiches*pickles + 9.0*ham_sandwiches, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(13*kale_salads**2 + 3*ham_sandwiches**2 >= 23)
m.addConstr(9*kale_salads**2 + 12*pickles**2 >= 20)
m.addConstr(13*oreos + 10*bowls_of_pasta + 9*kale_salads + 3*ham_sandwiches + 12*pickles >= 20)
m.addConstr(11*oreos**2 + 9*kale_salads**2 >= 20)
m.addConstr(14*ham_sandwiches**2 + 4*pickles**2 >= 18)
m.addConstr(11*oreos + 4*pickles >= 14)
m.addConstr(11*oreos + 4*bowls_of_pasta + 9*kale_salads >= 15)
m.addConstr(9*kale_salads + 14*ham_sandwiches + 4*pickles >= 15)
m.addConstr(11*oreos**2 + 9*kale_salads**2 + 4*pickles**2 >= 15)
m.addConstr(11*oreos + 4*bowls_of_pasta + 9*kale_salads >= 25)
m.addConstr(9*kale_salads + 14*ham_sandwiches + 4*pickles >= 25)
m.addConstr(11*oreos + 9*kale_salads + 4*pickles >= 25)
m.addConstr(11*oreos + 4*bowls_of_pasta + 9*kale_salads >= 20)
m.addConstr(9*kale_salads + 14*ham_sandwiches + 4*pickles >= 20)
m.addConstr(11*oreos + 9*kale_salads + 4*pickles >= 20)
m.addConstr(11*oreos + 4*bowls_of_pasta + 9*kale_salads + 14*ham_sandwiches + 4*pickles >= 20)
m.addConstr(4*kale_salads**2 - 3*ham_sandwiches**2 >= 0)
m.addConstr(2*oreos - 4*pickles >= 0)
m.addConstr(-2*ham_sandwiches**2 + 5*pickles**2 >= 0)

# ... (rest of the constraints, similarly translated)

m.addConstr(13*oreos + 10*bowls_of_pasta + 9*kale_salads + 3*ham_sandwiches + 12*pickles <= 158)
m.addConstr(11*oreos + 4*bowls_of_pasta + 9*kale_salads + 14*ham_sandwiches + 4*pickles <= 148)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

