
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0, ub=None) # oreos
x1 = m.addVar(name="x1", lb=0, ub=None, integrality=0) # bowls of pasta, can be fractional
x2 = m.addVar(name="x2", lb=0, ub=None, integrality=1) # kale salads, integer
x3 = m.addVar(name="x3", lb=0, ub=None, integrality=1) # ham sandwiches, integer
x4 = m.addVar(name="x4", lb=0, ub=None, integrality=1) # pickles, integer

# Objective function
m.setObjective(2.29*x0**2 + 5.26*x0*x1 + 2.95*x0*x3 + 5.47*x1**2 + 9.05*x1*x2 + 3.65*x3*x4 + 9.0*x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(x0 >= 1) 
m.addConstr(x0 >= 1) 
m.addConstr(x1 >= 1) 
m.addConstr(x1 >= 1) 
m.addConstr(x2 >= 1) 
m.addConstr(x2 >= 1) 
m.addConstr(x3 >= 1) 
m.addConstr(x3 >= 1) 
m.addConstr(x4 >= 1) 
m.addConstr(x4 >= 1) 
m.addConstr(x2**2 + x3**2 >= 23) 
m.addConstr(x2**2 + x4**2 >= 20) 
m.addConstr(13*x0 + 10*x1 + 9*x2 + 3*x3 + 12*x4 >= 20) 
m.addConstr(121*x0**2 + 81*x2**2 >= 20) 
m.addConstr(196*x3**2 + 16*x4**2 >= 18) 
m.addConstr(11*x0 + 4*x4 >= 14) 
m.addConstr(11*x0 + 4*x1 + 9*x2 >= 15) 
m.addConstr(9*x2 + 14*x3 + 4*x4 >= 15) 
m.addConstr(121*x0**2 + 81*x2**2 + 16*x4**2 >= 15) 
m.addConstr(11*x0 + 4*x1 + 9*x2 >= 25) 
m.addConstr(9*x2 + 14*x3 + 4*x4 >= 25) 
m.addConstr(11*x0 + 9*x2 + 4*x4 >= 25) 
m.addConstr(11*x0 + 4*x1 + 9*x2 >= 20) 
m.addConstr(9*x2 + 14*x3 + 4*x4 >= 20) 
m.addConstr(11*x0 + 9*x2 + 4*x4 >= 20) 
m.addConstr(11*x0 + 4*x1 + 9*x2 + 14*x3 + 4*x4 >= 20) 
m.addConstr(4*x2**2 - 3*x3**2 >= 0) 
m.addConstr(2*x0 - 4*x4 >= 0) 
m.addConstr(-2*x3**2 + 5*x4**2 >= 0) 
m.addConstr(10*x1 + 12*x4 <= 154) 
m.addConstr(9*x2 + 12*x4 <= 58) 
m.addConstr(10*x1 + 9*x2 <= 66) 
m.addConstr(3*x3 + 12*x4 <= 143) 
m.addConstr(169*x0**2 + 100*x1**2 <= 130) 
m.addConstr(10*x1 + 3*x3 <= 82) 
m.addConstr(13*x0 + 10*x1 + 3*x3 <= 33) 
m.addConstr(13*x0 + 10*x1 + 12*x4 <= 106) 
m.addConstr(4*x1 + 4*x4 <= 46) 
m.addConstr(11*x0 + 4*x4 <= 75) 
m.addConstr(11*x0 + 14*x3 <= 128) 
m.addConstr(9*x2 + 14*x3 <= 88) 
m.addConstr(16*x1**2 + 81*x2**2 <= 45) 
m.addConstr(4*x1 + 14*x3 <= 109) 
m.addConstr(14*x3 + 4*x4 <= 79) 
m.addConstr(9*x2 + 4*x4 <= 121) 
m.addConstr(4*x1 + 9*x2 + 14*x3 <= 101) 
m.addConstr(121*x0**2 + 81*x2**2 + 196*x3**2 <= 33) 
m.addConstr(4*x1 + 9*x2 + 4*x4 <= 128) 
m.addConstr(4*x1 + 14*x3 + 4*x4 <= 141)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
else:
    print("No solution found")
