
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    oranges = model.addVar(vtype=GRB.INTEGER, name="oranges")
    cornichons = model.addVar(vtype=GRB.INTEGER, name="cornichons")

    # Set objective function
    model.setObjective(9*oranges*cornichons + 6*cornichons**2 + 5*oranges + 2*cornichons, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(1*oranges + 11*cornichons >= 21, "c0")
    model.addConstr(12**2*oranges + 3**2*cornichons >= 38, "c1")
    model.addConstr(8**2*oranges + 4**2*cornichons >= 46, "c2")
    model.addConstr(6*oranges + 9*cornichons >= 21, "c3")
    model.addConstr(-5*oranges**2 + 7*cornichons**2 >= 0, "c4")
    model.addConstr(1**2*oranges + 11**2*cornichons <= 36, "c5")
    model.addConstr(1*oranges + 11*cornichons <= 36, "c6")
    model.addConstr(12*oranges + 3*cornichons <= 57, "c7")
    model.addConstr(8**2*oranges + 4**2*cornichons <= 144, "c8")
    model.addConstr(6*oranges + 9*cornichons <= 74, "c9")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimal objective value: {model.objVal}")
        print(f"Oranges: {oranges.x}")
        print(f"Cornichons: {cornichons.x}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
