
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="oranges", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="cornichons", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(9*x1*x2 + 6*x2**2 + 5*x1 + 2*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + 11*x2 >= 21)
    model.addConstr(12**2*x1**2 + 3**2*x2**2 >= 38)
    model.addConstr(8**2*x1**2 + 4**2*x2**2 >= 46)
    model.addConstr(6*x1 + 9*x2 >= 21)
    model.addConstr(-5*x1**2 + 7*x2**2 >= 0)
    model.addConstr((x1 + 11*x2)**2 <= 36)
    model.addConstr(12*x1 + 3*x2 <= 57)
    model.addConstr(8*x1 + 4*x2 <= 144)
    model.addConstr(6*x1 + 9*x2 <= 74)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("oranges: ", x1.varValue)
        print("cornichons: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
