
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
x = m.addVars(6, lb=0, vtype=gp.GRB.CONTINUOUS, name=["John", "Laura", "Bobby", "Ringo", "Mary", "George"])


# Set objective
m.setObjective(3.33 * x[0] + 2.81 * x[1] + 7.48 * x[2] + 5.12 * x[3] + 4.1 * x[4] + 9.72 * x[5], gp.GRB.MAXIMIZE)

# Resource constraints
resource_constraints = {
    'r0': {'upper_bound': 222, 'coefficients': [19, 4, 19, 11, 4, 1]},
    'r1': {'upper_bound': 225, 'coefficients': [9, 21, 8, 5, 16, 23]},
    'r2': {'upper_bound': 127, 'coefficients': [11, 4, 8, 17, 4, 5]},
    'r3': {'upper_bound': 152, 'coefficients': [18, 21, 12, 20, 23, 21]},
    'r4': {'upper_bound': 130, 'coefficients': [21, 7, 9, 14, 9, 17]}
}

for resource, data in resource_constraints.items():
    m.addConstr(gp.quicksum(data['coefficients'][i] * x[i] for i in range(6)) <= data['upper_bound'], name=resource)


# Additional constraints (parsed from the input)
additional_constraints = [
    (19 * x[0] + 1 * x[5] >= 27),
    (4 * x[1] + 4 * x[4] <= 67)
    # ... (Add all other constraints here)
]

for constraint in additional_constraints:
    m.addConstr(constraint)

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

