
from gurobipy import *

# Create a model
m = Model("Optimization Problem")

# Define variables
x1, x2, x3, x4, x5, x6 = m.addVars(6, name=['hours worked by John', 'hours worked by Laura', 
                                         'hours worked by Bobby', 'hours worked by Ringo', 
                                         'hours worked by Mary', 'hours worked by George'])

# Define objective function
m.setObjective(x1 + x2 + x3 + x4 + x5 + x6, GRB.MAXIMIZE)

# Define constraints
m.addConstr(11*x1 + 12*x2 + 13*x3 + 14*x4 + 15*x5 + 16*x6 >= 200, name='Productivity rating constraint')
m.addConstr(21*x1 + 22*x2 + 23*x3 + 24*x4 + 25*x5 + 26*x6 <= 300, name='Cost per hour constraint')
m.addConstr(31*x1 + 32*x2 + 33*x3 + 34*x4 + 35*x5 + 36*x6 >= 400, name='Productivity rating constraint')
m.addConstr(41*x1 + 42*x2 + 43*x3 + 44*x4 + 45*x5 + 46*x6 <= 500, name='Likelihood to quit index constraint')

# Optimize the model
m.optimize()
