
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("maximize_food")

    # Create variables
    green_beans = m.addVar(vtype=gp.GRB.INTEGER, name="green_beans")
    oreos = m.addVar(vtype=gp.GRB.INTEGER, name="oreos")
    bowls_of_cereal = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bowls_of_cereal")


    # Set objective function
    m.setObjective(7.91 * green_beans + 6.76 * oreos + 7.47 * bowls_of_cereal, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(green_beans + 5 * oreos >= 34, "c0")
    m.addConstr(green_beans + bowls_of_cereal >= 43, "c1")
    m.addConstr(10 * green_beans + 3 * oreos + 17 * bowls_of_cereal >= 48, "c2")
    m.addConstr(green_beans + 5 * oreos <= 95, "c3")
    m.addConstr(green_beans + 5 * oreos + bowls_of_cereal <= 127, "c4")
    m.addConstr(3 * oreos + 17 * bowls_of_cereal <= 72, "c5")
    m.addConstr(10 * green_beans + 17 * bowls_of_cereal <= 207, "c6")
    m.addConstr(10 * green_beans + 3 * oreos + 17 * bowls_of_cereal <= 203, "c7")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization was infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
