
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="green_beans", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="oreos", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="bowls_of_cereal")

# Define the objective function
m.setObjective(7.91*x0 + 6.76*x1 + 7.47*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x0 + 5*x1 >= 34)
m.addConstr(x0 + x2 >= 43)
m.addConstr(10*x0 + 3*x1 + 17*x2 >= 48)
m.addConstr(x0 + 5*x1 <= 95)
m.addConstr(x0 + 5*x1 + x2 <= 127)
m.addConstr(3*x1 + 17*x2 <= 72)
m.addConstr(10*x0 + 17*x2 <= 207)
m.addConstr(10*x0 + 3*x1 + 17*x2 <= 203)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Green beans: ", x0.varValue)
    print("Oreos: ", x1.varValue)
    print("Bowls of cereal: ", x2.varValue)
else:
    print("The model is infeasible")
