
import gurobipy as gp

# Create a new model
m = gp.Model("maximize_food")

# Create variables
rotisserie_chickens = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="rotisserie_chickens")
apple_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apple_pies")


# Set objective function
m.setObjective(1 * rotisserie_chickens + 1 * apple_pies, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(12 * rotisserie_chickens + 1 * apple_pies >= 41, "fat_lower_bound")
m.addConstr(14 * rotisserie_chickens + 15 * apple_pies >= 20, "carbohydrates_lower_bound")
m.addConstr(10 * rotisserie_chickens - 8 * apple_pies >= 0, "custom_constraint")
m.addConstr(12 * rotisserie_chickens + 1 * apple_pies <= 48, "fat_upper_bound")
m.addConstr(14 * rotisserie_chickens + 15 * apple_pies <= 35, "carbohydrates_upper_bound")



# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

