
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables (allowing for fractional amounts)
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="rotisserie_chickens")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apple_pies")

# Objective function: Maximize the quantity of both items
m.setObjective(x0 + x1, GRB.MAXIMIZE)

# Constraints
m.addConstr(12*x0 + x1 >= 41, name="fat_minimum")
m.addConstr(14*x0 + 15*x1 >= 20, name="carbohydrates_minimum")
m.addConstr(10*x0 - 8*x1 >= 0, name="combination_constraint")
m.addConstr(12*x0 + x1 <= 48, name="fat_maximum")
m.addConstr(14*x0 + 15*x1 <= 35, name="carbohydrates_maximum")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Rotisserie Chickens: {x0.x}")
    print(f"Apple Pies: {x1.x}")
else:
    print("No optimal solution found")

