
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="rotisserie_chickens", lb=0)  # Assuming non-negative
    x2 = model.addVar(name="apple_pies", lb=0)  # Assuming non-negative

    # Objective function
    model.setObjective(x1 + x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(12*x1 + x2 >= 41, name="fat_requirement")
    model.addConstr(14*x1 + 15*x2 >= 20, name="carbohydrates_requirement")
    model.addConstr(10*x1 - 8*x2 >= 0, name="linear_combination")
    model.addConstr(12*x1 + x2 <= 92, name="max_fat")
    model.addConstr(14*x1 + 15*x2 <= 58, name="max_carbohydrates")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Rotisserie chickens: {x1.varValue}")
        print(f"Apple pies: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
