
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_b7 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")
vitamin_b9 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b9")
vitamin_b4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b4")
vitamin_b12 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b12")
vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")


# Set objective function
m.setObjective(4.65 * vitamin_b7 + 1.73 * vitamin_b9 + 1.55 * vitamin_b4 + 7.12 * vitamin_b12 + 4.13 * vitamin_e, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9 * vitamin_b9 + 5 * vitamin_b12 >= 24)
m.addConstr(5 * vitamin_b12 + 10 * vitamin_e >= 46)
m.addConstr(14 * vitamin_b4 + 5 * vitamin_b12 >= 15)
m.addConstr(7 * vitamin_b7 + 10 * vitamin_e >= 39)
m.addConstr(7 * vitamin_b7 + 9 * vitamin_b9 + 14 * vitamin_b4 >= 45)
m.addConstr(7 * vitamin_b7 + 9 * vitamin_b9 + 10 * vitamin_e >= 45)
m.addConstr(7 * vitamin_b7 + 9 * vitamin_b9 + 5 * vitamin_b12 >= 45)
m.addConstr(9 * vitamin_b9 + 14 * vitamin_b4 + 5 * vitamin_b12 >= 45)
m.addConstr(9 * vitamin_b9 + 5 * vitamin_b12 + 10 * vitamin_e >= 45)
m.addConstr(9 * vitamin_b9 + 14 * vitamin_b4 + 10 * vitamin_e >= 45)
m.addConstr(7 * vitamin_b7 + 14 * vitamin_b4 + 10 * vitamin_e >= 45)
m.addConstr(7 * vitamin_b7 + 9 * vitamin_b9 + 14 * vitamin_b4 + 5 * vitamin_b12 + 10 * vitamin_e >= 42)
m.addConstr(-9 * vitamin_b7 + 3 * vitamin_e >= 0)
m.addConstr(9 * vitamin_b9 + 5 * vitamin_b12 + 10 * vitamin_e <= 145)
m.addConstr(9 * vitamin_b9 + 14 * vitamin_b4 + 5 * vitamin_b12 <= 220)
m.addConstr(14 * vitamin_b4 + 5 * vitamin_b12 + 10 * vitamin_e <= 67)
m.addConstr(7 * vitamin_b7 + 9 * vitamin_b9 + 10 * vitamin_e <= 206)
m.addConstr(7 * vitamin_b7 + 9 * vitamin_b9 + 14 * vitamin_b4 <= 55)
m.addConstr(7 * vitamin_b7 + 5 * vitamin_b12 + 10 * vitamin_e <= 49)
m.addConstr(7 * vitamin_b7 + 9 * vitamin_b9 + 14 * vitamin_b4 + 5 * vitamin_b12 + 10 * vitamin_e <= 232)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

