
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="potassium")
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_B7")
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_B9")
    x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="magnesium")

    # Set objective function
    m.setObjective(8.47 * x0 + 8.07 * x1 + 5.49 * x2 + 3.6 * x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4 * x0 + 5 * x1 + 3 * x2 + 5 * x3 <= 47, "c0")
    m.addConstr(5 * x1 + 5 * x3 >= 5, "c1")
    m.addConstr(3 * x2 + 5 * x3 >= 4, "c2")
    m.addConstr(4 * x0 + 5 * x1 + 5 * x3 >= 8, "c3")
    m.addConstr(4 * x0 + 5 * x1 + 3 * x2 >= 8, "c4")
    m.addConstr(4 * x0 + 5 * x1 + 5 * x3 >= 11, "c5")
    m.addConstr(4 * x0 + 5 * x1 + 3 * x2 >= 11, "c6")
    m.addConstr(5 * x1 + 3 * x2 <= 27, "c7")
    m.addConstr(5 * x1 + 5 * x3 <= 36, "c8")
    m.addConstr(4 * x0 + 5 * x1 + 5 * x3 <= 26, "c9")
    m.addConstr(4 * x0 + 3 * x2 + 5 * x3 <= 20, "c10")
    m.addConstr(5 * x1 + 3 * x2 + 5 * x3 <= 31, "c11")
    m.addConstr(4 * x0 + 5 * x1 + 3 * x2 <= 28, "c12")
    m.addConstr(4 * x0 + 5 * x1 + 3 * x2 + 5 * x3 <= 28, "c13")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
