
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="x1", vtype=gp.GRB.INTEGER)  # milligrams of potassium
x2 = m.addVar(name="x2")  # milligrams of vitamin B7
x3 = m.addVar(name="x3")  # milligrams of vitamin B9
x4 = m.addVar(name="x4")  # milligrams of magnesium

# Objective function
m.setObjective(8.47 * x1 + 8.07 * x2 + 5.49 * x3 + 3.6 * x4, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(4 * x1 <= 47)
m.addConstr(5 * x2 <= 47)
m.addConstr(3 * x3 <= 47)
m.addConstr(5 * x4 <= 47)
m.addConstr(5 * x2 + 5 * x4 >= 5)
m.addConstr(3 * x3 + 5 * x4 >= 4)
m.addConstr(4 * x1 + 5 * x2 + 5 * x4 >= 8)
m.addConstr(4 * x1 + 5 * x2 + 3 * x3 >= 8)
m.addConstr(4 * x1 + 5 * x2 + 5 * x4 >= 11)
m.addConstr(4 * x1 + 5 * x2 + 3 * x3 >= 11)
m.addConstr(5 * x2 + 3 * x3 <= 27)
m.addConstr(5 * x2 + 5 * x4 <= 36)
m.addConstr(4 * x1 + 5 * x2 + 5 * x4 <= 26)
m.addConstr(4 * x1 + 3 * x3 + 5 * x4 <= 20)
m.addConstr(5 * x2 + 3 * x3 + 5 * x4 <= 31)
m.addConstr(4 * x1 + 5 * x2 + 3 * x3 <= 28)
m.addConstr(4 * x1 + 5 * x2 + 3 * x3 + 5 * x4 <= 28)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of potassium: {x1.varValue}")
    print(f"Milligrams of vitamin B7: {x2.varValue}")
    print(f"Milligrams of vitamin B9: {x3.varValue}")
    print(f"Milligrams of magnesium: {x4.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
