
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(5, lb=0, name=["George", "Laura", "Bill", "Paul", "Bobby"])

# Set objective function
m.setObjective(7*x[0] + 4*x[1] + 7*x[2] + 4*x[3] + 8*x[4], gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6.21*x[0] + 3.68*x[1] >= 18)
m.addConstr(6.21*x[0] + 7.75*x[4] >= 12)
m.addConstr(3.68*x[1] + 7.75*x[4] >= 7)
m.addConstr(0.1*x[2] + 7.75*x[4] >= 9)
m.addConstr(6.21*x[0] + 3.68*x[1] + 7.75*x[4] >= 12)
m.addConstr(3.68*x[1] + 0.1*x[2] + 6.54*x[3] >= 12)
m.addConstr(3.68*x[1] + 0.1*x[2] + 7.75*x[4] >= 12)
m.addConstr(6.21*x[0] + 3.68*x[1] + 7.75*x[4] >= 13)
m.addConstr(3.68*x[1] + 0.1*x[2] + 6.54*x[3] >= 13)
m.addConstr(3.68*x[1] + 0.1*x[2] + 7.75*x[4] >= 13)
m.addConstr(6.21*x[0] + 3.68*x[1] + 7.75*x[4] >= 19)
m.addConstr(3.68*x[1] + 0.1*x[2] + 6.54*x[3] >= 19)
m.addConstr(3.68*x[1] + 0.1*x[2] + 7.75*x[4] >= 19)
m.addConstr(6.21*x[0] + 3.68*x[1] + 0.1*x[2] + 6.54*x[3] + 7.75*x[4] >= 19)
# ... (rest of the constraints from the JSON)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

