
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=0, name="x0")  # hours worked by George
    x1 = model.addVar(lb=0, name="x1")  # hours worked by Laura
    x2 = model.addVar(lb=0, name="x2")  # hours worked by Bill
    x3 = model.addVar(lb=0, name="x3")  # hours worked by Paul
    x4 = model.addVar(lb=0, name="x4")  # hours worked by Bobby

    # Objective function
    model.setObjective(7*x0 + 4*x1 + 7*x2 + 4*x3 + 8*x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(6.21*x0 + 3.68*x1 >= 18)
    model.addConstr(6.21*x0 + 7.75*x4 >= 12)
    model.addConstr(3.68*x1 + 7.75*x4 >= 7)
    model.addConstr(0.1*x2 + 7.75*x4 >= 9)
    model.addConstr(6.2*x0 + 4.32*x3 >= 20)
    model.addConstr(6.44*x2 + 7.8*x4 >= 6)
    model.addConstr(0.89*x0 + 3.39*x3 >= 21)
    model.addConstr(7*x1 - 8*x2 >= 0)
    model.addConstr(-2*x0 + 8*x2 >= 0)
    model.addConstr(3.68*x1 + 0.1*x2 <= 88)
    model.addConstr(0.1*x2 + 7.75*x4 <= 77)

    # Add all other constraints...

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print("Hours worked by George:", x0.varValue)
        print("Hours worked by Laura:", x1.varValue)
        print("Hours worked by Bill:", x2.varValue)
        print("Hours worked by Paul:", x3.varValue)
        print("Hours worked by Bobby:", x4.varValue)
        print("Objective function value:", model.objVal)
    else:
        print("No optimal solution found.")

solve_optimization_problem()
