
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    paper_clips = m.addVar(vtype=gp.GRB.INTEGER, name="paper_clips")
    red_pens = m.addVar(vtype=gp.GRB.INTEGER, name="red_pens")


    # Set objective function
    m.setObjective(1 * paper_clips + 1 * red_pens, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(15 * paper_clips + 8 * red_pens >= 30, "dollar_cost_min")
    m.addConstr(24 * paper_clips + 24 * red_pens >= 33, "employee_satisfaction_min")
    m.addConstr(23 * paper_clips + 19 * red_pens >= 44, "workplace_safety_min")
    m.addConstr(-3 * paper_clips + 5 * red_pens >= 0, "custom_constraint")
    m.addConstr(15 * paper_clips + 8 * red_pens <= 59, "dollar_cost_max")
    m.addConstr(24 * paper_clips + 24 * red_pens <= 74, "employee_satisfaction_max")
    m.addConstr(23 * paper_clips + 19 * red_pens <= 68, "workplace_safety_max")



    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('paper_clips: %g' % paper_clips.x)
        print('red_pens: %g' % red_pens.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
