
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Create variables
x1 = m.addVar(vtype=GRB.INTEGER, name="paper_clips")
x2 = m.addVar(vtype=GRB.INTEGER, name="red_pens")

# Set the objective function
m.setObjective(1*x1 + 1*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x1 + 8*x2 >= 30, "min_cost")
m.addConstr(24*x1 + 24*x2 >= 33, "min_employee_satisfaction")
m.addConstr(23*x1 + 19*x2 >= 44, "min_workplace_safety")
m.addConstr(-3*x1 + 5*x2 >= 0, "linear_inequality")
m.addConstr(15*x1 + 8*x2 <= 59, "max_cost")
m.addConstr(24*x1 + 24*x2 <= 74, "max_employee_satisfaction")
m.addConstr(23*x1 + 19*x2 <= 68, "max_workplace_safety")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Paper Clips: {x1.x}")
    print(f"Red Pens: {x2.x}")
else:
    print("No optimal solution found.")
