
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="paper_clips", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="red_pens", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(x1 + x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(15 * x1 + 8 * x2 >= 30)
    model.addConstr(24 * x1 + 24 * x2 >= 33)
    model.addConstr(23 * x1 + 19 * x2 >= 44)
    model.addConstr(-3 * x1 + 5 * x2 >= 0)
    model.addConstr(15 * x1 + 8 * x2 <= 59)
    model.addConstr(24 * x1 + 24 * x2 <= 74)
    model.addConstr(23 * x1 + 19 * x2 <= 68)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Paper clips: {x1.varValue}")
        print(f"Red pens: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
