
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="x0")  # hours worked by Peggy
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="x1")  # hours worked by Bobby
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # hours worked by John


    # Set objective function
    m.setObjective(1*x0 + 9*x1 + 4*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(7.65*x0 + 21.97*x1 >= 63)
    m.addConstr(7.65*x0 + 25.24*x2 >= 54)
    m.addConstr(7.65*x0 + 21.97*x1 + 25.24*x2 >= 54)
    m.addConstr(3.82*x1 + 20.52*x2 >= 19)
    m.addConstr(24.5*x0 + 20.52*x2 >= 22)
    m.addConstr(24.5*x0 + 3.82*x1 + 20.52*x2 >= 22)
    m.addConstr(-1*x0 + 9*x2 >= 0)
    m.addConstr(1*x1 - 2*x2 >= 0)
    m.addConstr(24.5*x0 + 3.82*x1 <= 93)
    m.addConstr(24.5*x0 + 20.52*x2 <= 46)
    m.addConstr(3.82*x1 + 20.52*x2 <= 108)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
