
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name='x0', lb=0, type=gurobi.GRB.INTEGER)  # hours worked by Peggy
x1 = m.addVar(name='x1', lb=0, type=gurobi.GRB.INTEGER)  # hours worked by Bobby
x2 = m.addVar(name='x2', lb=0)  # hours worked by John

# Set the objective function
m.setObjective(1*x0 + 9*x1 + 4*x2, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(7.65*x0 + 21.97*x1 >= 63)
m.addConstr(7.65*x0 + 25.24*x2 >= 54)
m.addConstr(7.65*x0 + 21.97*x1 + 25.24*x2 >= 54)
m.addConstr(3.82*x1 + 20.52*x2 >= 19)
m.addConstr(24.5*x0 + 20.52*x2 >= 22)
m.addConstr(24.5*x0 + 3.82*x1 + 20.52*x2 >= 22)
m.addConstr(-1*x0 + 9*x2 >= 0)
m.addConstr(x1 - 2*x2 >= 0)
m.addConstr(24.5*x0 + 3.82*x1 <= 93)
m.addConstr(24.5*x0 + 20.52*x2 <= 46)
m.addConstr(3.82*x1 + 20.52*x2 <= 108)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Hours worked by Peggy: ', x0.varValue)
    print('Hours worked by Bobby: ', x1.varValue)
    print('Hours worked by John: ', x2.varValue)
else:
    print('The model is infeasible')
