
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("plant_optimization")

# Create variables
ferns = m.addVar(vtype=GRB.INTEGER, name="ferns")
petunias = m.addVar(vtype=GRB.INTEGER, name="petunias")
strawberry_bushes = m.addVar(vtype=GRB.INTEGER, name="strawberry_bushes")

# Set objective function
m.setObjective(4 * ferns + 5 * petunias + 4 * strawberry_bushes, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12 * petunias + 4 * strawberry_bushes >= 49, "c0")
m.addConstr(-8 * ferns + 4 * strawberry_bushes >= 0, "c1")
m.addConstr(12 * petunias + 4 * strawberry_bushes <= 180, "c2")
m.addConstr(9 * ferns + 4 * strawberry_bushes <= 89, "c3")
m.addConstr(9 * ferns + 12 * petunias + 4 * strawberry_bushes <= 89, "c4")
m.addConstr(9 * ferns + 12 * petunias + 4 * strawberry_bushes <= 235, "c5")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('ferns:', ferns.x)
    print('petunias:', petunias.x)
    print('strawberry_bushes:', strawberry_bushes.x)
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

