
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Create variables
x1 = m.addVar(vtype=GRB.INTEGER, name="ferns")
x2 = m.addVar(vtype=GRB.INTEGER, name="petunias")
x3 = m.addVar(vtype=GRB.INTEGER, name="strawberry_bushes")

# Set the objective function
m.setObjective(4*x1 + 5*x2 + 4*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*x2 + 4*x3 >= 49, "min_beauty_petunias_strawberry")
m.addConstr(-8*x1 + 4*x3 >= 0, "ferns_strawberry_constraint")
m.addConstr(12*x2 + 4*x3 <= 180, "max_beauty_petunias_strawberry")
m.addConstr(9*x1 + 4*x3 <= 89, "max_beauty_ferns_strawberry")
m.addConstr(9*x1 + 12*x2 + 4*x3 <= 89, "total_max_beauty")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print('%s %g' % (v.varName, v.x))

print('Obj: %g' % m.objVal)
