
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="ferns", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="petunias", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="strawberry_bushes", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(4*x1 + 5*x2 + 4*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(12*x2 + 4*x3 >= 49)
    model.addConstr(-8*x1 + 4*x3 >= 0)
    model.addConstr(12*x2 + 4*x3 <= 180)
    model.addConstr(9*x1 + 4*x3 <= 89)
    model.addConstr(9*x1 + 12*x2 + 4*x3 <= 89)

    # Non-negativity constraints (implicit in Gurobi for integer variables)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Ferns: ", x1.varValue)
        print("Petunias: ", x2.varValue)
        print("Strawberry bushes: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
