
import gurobipy as gp

# Create a new model
m = gp.Model("military_optimization")

# Create variables
light_infantry = m.addVar(vtype=gp.GRB.INTEGER, name="light_infantry")
reconnaissance = m.addVar(vtype=gp.GRB.INTEGER, name="reconnaissance")
logistics = m.addVar(vtype=gp.GRB.INTEGER, name="logistics")
armored = m.addVar(vtype=gp.GRB.INTEGER, name="armored")


# Set objective function
m.setObjective(5.84*light_infantry**2 + 3.19*light_infantry*logistics + 8.94*reconnaissance**2 + 3.49*reconnaissance*logistics + 8.2*logistics**2 + 4.28*armored**2 + 3.68*light_infantry + 3.35*logistics, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5.17*light_infantry + 9.31*reconnaissance + 9.96*logistics + 10.01*armored <= 466, "r0_upper_bound")
m.addConstr(11.81*light_infantry + 10.28*reconnaissance + 7.28*logistics + 7.69*armored <= 324, "r1_upper_bound")

m.addConstr(9.31*reconnaissance + 9.96*logistics + 10.01*armored >= 100, "c1")
m.addConstr(5.17*light_infantry**2 + 9.31*reconnaissance**2 + 10.01*armored**2 >= 100, "c2")
m.addConstr(5.17*light_infantry + 9.31*reconnaissance + 9.96*logistics >= 100, "c3")
m.addConstr(9.31*reconnaissance + 9.96*logistics + 10.01*armored >= 82, "c4")
m.addConstr(5.17*light_infantry + 9.31*reconnaissance + 10.01*armored >= 82, "c5")
m.addConstr(5.17*light_infantry + 9.31*reconnaissance + 9.96*logistics >= 82, "c6")
m.addConstr(9.31*reconnaissance + 9.96*logistics + 10.01*armored >= 87, "c7")
m.addConstr(5.17*light_infantry + 9.31*reconnaissance + 10.01*armored >= 87, "c8")
m.addConstr(5.17*light_infantry + 9.31*reconnaissance + 9.96*logistics >= 87, "c9")

m.addConstr(10.28*reconnaissance**2 + 7.28*logistics**2 + 7.69*armored**2 >= 75, "c10")
m.addConstr(11.81*light_infantry + 10.28*reconnaissance + 7.69*armored >= 75, "c11")
m.addConstr(11.81*light_infantry + 7.28*logistics + 7.69*armored >= 75, "c12")
m.addConstr(10.28*reconnaissance**2 + 7.28*logistics**2 + 7.69*armored**2 >= 56, "c13")
m.addConstr(11.81*light_infantry + 10.28*reconnaissance + 7.69*armored >= 56, "c14")
m.addConstr(11.81*light_infantry + 7.28*logistics + 7.69*armored >= 56, "c15")
m.addConstr(10.28*reconnaissance + 7.28*logistics + 7.69*armored >= 60, "c16")
m.addConstr(11.81*light_infantry + 10.28*reconnaissance + 7.69*armored >= 60, "c17")
m.addConstr(11.81*light_infantry + 7.28*logistics + 7.69*armored >= 60, "c18")


m.addConstr(5.17*light_infantry + 10.01*armored <= 247, "c19")
m.addConstr(9.96*logistics + 10.01*armored <= 348, "c20")
m.addConstr(5.17*light_infantry + 9.96*logistics <= 382, "c21")
m.addConstr(9.31*reconnaissance**2 + 9.96*logistics**2 <= 234, "c22")
m.addConstr(5.17*light_infantry + 9.31*reconnaissance <= 189, "c23")
m.addConstr(9.31*reconnaissance + 10.01*armored <= 359, "c24")
m.addConstr(5.17*light_infantry + 9.31*reconnaissance + 10.01*armored <= 227, "c25")
m.addConstr(5.17*light_infantry + 9.31*reconnaissance + 9.96*logistics + 10.01*armored <= 227, "c26")

m.addConstr(10.28*reconnaissance + 7.69*armored <= 204, "c27")
m.addConstr(7.28*logistics**2 + 7.69*armored**2 <= 201, "c28")
m.addConstr(11.81*light_infantry + 10.28*reconnaissance + 7.28*logistics + 7.69*armored <= 201, "c29")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

