
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="light_infantry_companies")
x1 = m.addVar(vtype=GRB.INTEGER, name="reconnaissance_troops")
x2 = m.addVar(vtype=GRB.INTEGER, name="logistics_companies")
x3 = m.addVar(vtype=GRB.INTEGER, name="armored_companies")

# Objective function
m.setObjective(5.84*x0**2 + 3.19*x0*x2 + 8.94*x1**2 + 3.49*x1*x2 + 8.2*x2**2 + 4.28*x3**2 + 3.68*x0 + 3.35*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(5.17*x0 + 9.31*x1 + 9.96*x2 + 10.01*x3 <= 466)  # Total logistics footprint
m.addConstr(11.81*x0 + 10.28*x1 + 7.28*x2 + 7.69*x3 <= 324)  # Total logistical capacity

# Example of minimum and maximum constraints for combinations of units
m.addConstr(x0**2 + x1**2 + x3**2 >= 100)
m.addConstr(5.17*x0 + 9.31*x1 + 10.01*x3 <= 227)  # Maximum logistics footprint example

# Add other constraints as needed based on the problem description

# Optimize model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Obj:", m.objVal)
