
from gurobipy import *

# Create a new model
m = Model("Feasible_Solution")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="slices_of_pizza")
x2 = m.addVar(vtype=GRB.INTEGER, name="tomatoes")
x3 = m.addVar(vtype=GRB.INTEGER, name="green_beans")
x4 = m.addVar(vtype=GRB.INTEGER, name="apple_pies")
x5 = m.addVar(vtype=GRB.INTEGER, name="eggs", lb=16)  # Minimum of 16 eggs
x6 = m.addVar(vtype=GRB.INTEGER, name="blueberry_pies")

# Add constraints
m.addConstr(x1 + x2 >= 7)
m.addConstr(x1 + x5 >= 16)
m.addConstr(x2 + x3 >= 15)
m.addConstr(x4 <= 28)

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Solution found:")
    print(f"slices_of_pizza: {x1.x}")
    print(f"tomatoes: {x2.x}")
    print(f"green_beans: {x3.x}")
    print(f"apple_pies: {x4.x}")
    print(f"eggs: {x5.x}")
    print(f"blueberry_pies: {x6.x}")
else:
    print("No solution found")
