
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
jean = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="jean")
john = m.addVar(lb=0, vtype=GRB.INTEGER, name="john")
ringo = m.addVar(lb=0, vtype=GRB.INTEGER, name="ringo")
george = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="george")


# Set objective function
m.setObjective(8*jean**2 + 4*john*george + 7*ringo**2 + 7*jean + 8*george, GRB.MINIMIZE)

# Add constraints
m.addConstr(2.44*john**2 + 11.89*george**2 >= 29)
m.addConstr(2.44*jean**2 + 12.66*ringo**2 >= 15)
m.addConstr(12.66*ringo + 11.89*george >= 30)
m.addConstr(2.44*jean + 14.21*john + 12.66*ringo >= 33)
m.addConstr(2.44*jean + 14.21*john + 11.89*george >= 33)
m.addConstr(2.44*jean**2 + 12.66*ringo**2 + 11.89*george**2 >= 33)
m.addConstr(2.44*jean + 14.21*john + 12.66*ringo >= 16)
m.addConstr(2.44*jean**2 + 14.21*john**2 + 11.89*george**2 >= 16)
m.addConstr(2.44*jean**2 + 12.66*ringo**2 + 11.89*george**2 >= 16)
m.addConstr(2.44*jean + 14.21*john + 12.66*ringo >= 20)
m.addConstr(2.44*jean + 14.21*john + 11.89*george >= 20)
m.addConstr(2.44*jean**2 + 12.66*ringo**2 + 11.89*george**2 >= 20)
m.addConstr(2.44*jean + 14.21*john + 12.66*ringo + 11.89*george >= 20)
m.addConstr(8.27*ringo + 4.57*george >= 32)
m.addConstr(3.74*jean + 4.07*john >= 16)
m.addConstr(4.07*john + 4.57*george >= 32)
m.addConstr(3.74*jean**2 + 4.57*george**2 >= 48)
m.addConstr(4.07*john**2 + 8.27*ringo**2 >= 19)
m.addConstr(3.74*jean + 8.27*ringo >= 34)
m.addConstr(3.74*jean + 4.07*john + 8.27*ringo + 4.57*george >= 34)
m.addConstr(4*ringo - 5*george >= 0)
m.addConstr(9*jean - 5*george >= 0)
m.addConstr(2.44*jean + 14.21*john <= 36)
m.addConstr(14.21*john + 11.89*george <= 130)
m.addConstr(2.44*jean**2 + 11.89*george**2 <= 71)
m.addConstr(14.21*john**2 + 12.66*ringo**2 + 11.89*george**2 <= 131)
m.addConstr(2.44*jean + 14.21*john + 11.89*george <= 92)
m.addConstr(2.44*jean + 12.66*ringo + 11.89*george <= 76)
m.addConstr(3.74*jean + 4.57*george <= 59)
m.addConstr(3.74*jean + 4.07*john <= 116)
m.addConstr(3.74*jean + 8.27*ringo <= 196)
m.addConstr(3.74*jean**2 + 8.27*ringo**2 + 4.57*george**2 <= 177)
m.addConstr(4.07*john + 8.27*ringo + 4.57*george <= 57)
m.addConstr(3.74*jean + 4.07*john + 4.57*george <= 118)
m.addConstr(3.74*jean + 4.07*john + 8.27*ringo <= 146)



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

