
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=-gp.GRB.INFINITY)  # hours worked by Jean
x1 = m.addVar(name="x1", lb=0, vtype=gp.GRB.INTEGER)  # hours worked by John
x2 = m.addVar(name="x2", lb=0, vtype=gp.GRB.INTEGER)  # hours worked by Ringo
x3 = m.addVar(name="x3", lb=-gp.GRB.INFINITY)  # hours worked by George

# Objective function
m.setObjective(8*x0**2 + 4*x1*x3 + 7*x2**2 + 7*x0 + 8*x3, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(x0 == 2.44)  
m.addConstr(x1 == 14.21)  
m.addConstr(x2 == 12.66)  
m.addConstr(x3 == 11.89)  

# Correcting and adding constraints based on problem description
m.addConstr(x1**2 + x3**2 >= 29)
m.addConstr(x0**2 + x2**2 >= 15)
m.addConstr(x2 + x3 >= 30)
m.addConstr(x0 + x1 + x2 >= 33)
m.addConstr(x0 + x1 + x3 >= 33)
m.addConstr(x0**2 + x2**2 + x3**2 >= 33)
m.addConstr(x0 + x1 + x2 >= 16)
m.addConstr(x0**2 + x1**2 + x3**2 >= 16)
m.addConstr(x0**2 + x2**2 + x3**2 >= 16)
m.addConstr(x0 + x1 + x2 >= 20)
m.addConstr(x0 + x1 + x3 >= 20)
m.addConstr(x0**2 + x2**2 + x3**2 >= 20)
m.addConstr(x0 + x1 + x2 + x3 >= 20)
m.addConstr(x2 + x3 >= 32)
m.addConstr(x0 + x1 >= 16)
m.addConstr(x1 + x3 >= 32)
m.addConstr(x0**2 + x3**2 >= 48)
m.addConstr(x1**2 + x2**2 >= 19)
m.addConstr(x0 + x2 >= 34)
m.addConstr(x0 + x1 + x2 + x3 >= 34)
m.addConstr(4*x2 - 5*x3 >= 0)
m.addConstr(9*x0 - 5*x3 >= 0)
m.addConstr(x0 + x1 <= 36)
m.addConstr(x1 + x3 <= 130)
m.addConstr(x0**2 + x3**2 <= 71)
m.addConstr(x1**2 + x2**2 + x3**2 <= 131)
m.addConstr(x0 + x1 + x3 <= 92)
m.addConstr(x0 + x2 + x3 <= 76)
m.addConstr(x0 + x3 <= 59)
m.addConstr(x0 + x1 <= 116)
m.addConstr(x0 + x2 <= 196)
m.addConstr(x0**2 + x2**2 + x3**2 <= 177)
m.addConstr(x1 + x2 + x3 <= 57)
m.addConstr(x0 + x1 + x3 <= 118)
m.addConstr(x0 + x1 + x2 <= 146)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
