
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(name="vitamin_B2", lb=0)  # milligrams of vitamin B2
    x1 = m.addVar(name="vitamin_B1", lb=0)  # milligrams of vitamin B1
    x2 = m.addVar(name="zinc", lb=0)  # milligrams of zinc


    # Set objective function
    m.setObjective(x0**2 + 3*x0*x1 + 7*x1**2 + 6*x1*x2 + 2*x2**2 + 8*x0 + 8*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(13*x0 + 11*x1 <= 111, "c1")
    m.addConstr(13*x0**2 + 4*x2**2 <= 65, "c2")
    m.addConstr(13*x0 + 11*x1 + 4*x2 <= 51, "c3")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('vitamin_B2: %g' % x0.x)
        print('vitamin_B1: %g' % x1.x)
        print('zinc: %g' % x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

