
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B2")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B1")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_zinc")

# Define the objective function
m.setObjective(1*x1**2 + 3*x1*x2 + 7*x2**2 + 6*x2*x3 + 2*x3**2 + 8*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(13*x1 <= 128)
m.addConstr(11*x2 <= 128)
m.addConstr(4*x3 <= 128)
m.addConstr(13*x1 + 11*x2 <= 111)
m.addConstr((13*x1)**2 + (4*x3)**2 <= 65)
m.addConstr(13*x1 + 11*x2 + 4*x3 <= 51)
m.addConstr(x1 + x2 + x3 <= 51)

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B2: {x1.x}")
    print(f"Milligrams of Vitamin B1: {x2.x}")
    print(f"Milligrams of Zinc: {x3.x}")
else:
    print("No optimal solution found")
