
import gurobi

def optimize_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x2")
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x3")

    # Objective function
    model.setObjective(1*x1**2 + 3*x1*x2 + 7*x2**2 + 6*x2*x3 + 2*x3**2 + 8*x1 + 8*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(13*x1 <= 128)
    model.addConstr(11*x2 <= 128)
    model.addConstr(4*x3 <= 128)
    model.addConstr(13*x1 + 11*x2 <= 111)
    model.addConstr(13*x1**2 + 4*x3**2 <= 65)
    model.addConstr(13*x1 + 11*x2 + 4*x3 <= 51)
    model.addConstr(x1 + x2 + x3 <= 51)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"x1: {x1.varValue}")
        print(f"x2: {x2.varValue}")
        print(f"x3: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
