
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="x0") # milligrams of vitamin B6
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="x1") # milligrams of zinc
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # grams of fat


# Set objective function
m.setObjective(9*x0*x1 + 5*x0*x2 + 6*x1**2 + 2*x1*x2 + x2**2 + 6*x0 + 3*x1 + 9*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x0**2 + 6*x1**2 + 6*x2**2 >= 17)
m.addConstr(9*x0**2 + 10*x1**2 >= 13)
m.addConstr(8*x1 + 4*x2 >= 13)
m.addConstr(3*x0 + 8*x1 + 4*x2 >= 8)
m.addConstr(3*x0**2 + 6*x2**2 <= 39)
m.addConstr(6*x1 + 6*x2 <= 50)
m.addConstr(3*x0 + 6*x1 + 6*x2 <= 50)
m.addConstr(11*x0 + 5*x1 <= 69)
m.addConstr(5*x1 + 9*x2 <= 52)
m.addConstr(11*x0**2 + 9*x2**2 <= 42)
m.addConstr(11*x0 + 5*x1 + 9*x2 <= 74)
m.addConstr(9*x0 + 6*x2 <= 21)
m.addConstr(9*x0 + 10*x1 <= 61)
m.addConstr(9*x0 + 10*x1 + 6*x2 <= 61)
m.addConstr(3*x0**2 + 4*x2**2 <= 27)
m.addConstr(3*x0 + 8*x1 + 4*x2 <= 27)


# Resource Constraints (using provided data)
m.addConstr(3*x0 + 6*x1 + 6*x2 <= 71) # r0
m.addConstr(11*x0 + 5*x1 + 9*x2 <= 85) # r1
m.addConstr(9*x0 + 10*x1 + 6*x2 <= 64) # r2
m.addConstr(3*x0 + 8*x1 + 4*x2 <= 50) # r3



# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('x0: %g' % x0.x)
    print('x1: %g' % x1.x)
    print('x2: %g' % x2.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

