
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="milligrams_of_vitamin_B6", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="milligrams_of_zinc", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="grams_of_fat")

# Define the objective function
m.setObjective(9*x1*x2 + 5*x1*x3 + 6*x2**2 + 2*x2*x3 + x3**2 + 6*x1 + 3*x2 + 9*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 <= 71)
m.addConstr(11*x1 <= 85)
m.addConstr(9*x1 <= 64)
m.addConstr(3*x1 <= 50)
m.addConstr(6*x2 <= 71)
m.addConstr(5*x2 <= 85)
m.addConstr(10*x2 <= 64)
m.addConstr(8*x2 <= 50)
m.addConstr(6*x3 <= 71)
m.addConstr(9*x3 <= 85)
m.addConstr(6*x3 <= 64)
m.addConstr(4*x3 <= 50)
m.addConstr(3*x1**2 + 6*x2**2 + 6*x3**2 >= 17)
m.addConstr(9*x1**2 + 10*x2**2 >= 13)
m.addConstr(8*x2 + 4*x3 >= 13)
m.addConstr(3*x1 + 8*x2 + 4*x3 >= 8)
m.addConstr(3*x1**2 + 6*x3**2 <= 39)
m.addConstr(6*x2 + 6*x3 <= 50)
m.addConstr(3*x1 + 6*x2 + 6*x3 <= 50)
m.addConstr(11*x1 + 5*x2 <= 69)
m.addConstr(5*x2 + 9*x3 <= 52)
m.addConstr(11*x1**2 + 9*x3**2 <= 42)
m.addConstr(11*x1 + 5*x2 + 9*x3 <= 74)
m.addConstr(11*x1 + 5*x2 + 9*x3 <= 74)
m.addConstr(9*x1 + 6*x3 <= 21)
m.addConstr(9*x1 + 10*x2 <= 61)
m.addConstr(9*x1 + 10*x2 + 6*x3 <= 61)
m.addConstr(3*x1**2 + 4*x3**2 <= 27)
m.addConstr(3*x1 + 8*x2 + 4*x3 <= 27)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Milligrams of vitamin B6: ", x1.varValue)
    print("Milligrams of zinc: ", x2.varValue)
    print("Grams of fat: ", x3.varValue)
    print("Objective function value: ", m.objVal)
else:
    print("No optimal solution found.")
