
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
potatoes = m.addVar(lb=0, name="potatoes")
rotisserie_chickens = m.addVar(lb=0, name="rotisserie_chickens")
granola_bars = m.addVar(lb=0, name="granola_bars")
bowls_of_pasta = m.addVar(lb=0, name="bowls_of_pasta")
hamburgers = m.addVar(lb=0, name="hamburgers")


# Set objective function
m.setObjective(6.66*potatoes**2 + 6.99*potatoes*rotisserie_chickens + 1.01*potatoes*granola_bars + 8.74*potatoes*bowls_of_pasta + 8.29*potatoes*hamburgers + 8.07*rotisserie_chickens**2 + 4.59*rotisserie_chickens*granola_bars + 6.12*rotisserie_chickens*bowls_of_pasta + 5.96*rotisserie_chickens*hamburgers + 5.79*granola_bars**2 + 5.64*granola_bars*bowls_of_pasta + 4.8*granola_bars*hamburgers + 1.25*bowls_of_pasta**2 + 3.23*bowls_of_pasta*hamburgers + 8.29*hamburgers**2 + 1.54*potatoes + 1.35*rotisserie_chickens + 8.88*granola_bars + 9.19*bowls_of_pasta + 8.95*hamburgers, gp.GRB.MAXIMIZE)

# Add constraints
sourness_index = {
    'potatoes': 0.21,
    'rotisserie_chickens': 1.53,
    'granola_bars': 1.58,
    'bowls_of_pasta': 4.85,
    'hamburgers': 1.59
}

m.addConstr(sourness_index['potatoes']*potatoes + sourness_index['rotisserie_chickens']*rotisserie_chickens + sourness_index['granola_bars']*granola_bars + sourness_index['bowls_of_pasta']*bowls_of_pasta + sourness_index['hamburgers']*hamburgers <= 194)


constraints_text = [ # constraints from the prompt
    "1.53*x1 + 1.58*x2 >= 28",
    "0.21**2*x0**2 + 1.53**2*x1**2 >= 28",
    "1.58**2*x2**2 + 1.59**2*x4**2 >= 38",
    # ... (rest of the constraints)
]

variable_mapping = {
    'x0': potatoes,
    'x1': rotisserie_chickens,
    'x2': granola_bars,
    'x3': bowls_of_pasta,
    'x4': hamburgers
}

for constraint_text in constraints_text:
    for var_name, var in variable_mapping.items():
        constraint_text = constraint_text.replace(var_name, str(var))
    
    try:
        m.addConstr(eval(constraint_text))
    except:
        print(f"Failed to parse and add constraint: {constraint_text}")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

