
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(name="hours worked by Paul")
    x1 = model.addVar(name="hours worked by George")
    x2 = model.addVar(name="hours worked by Bobby")


    # Set objective function
    model.setObjective(6.32*x0**2 + 6.22*x0*x1 + 6.23*x0*x2 + 5.64*x0, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(11*x0 + 20*x1 >= 47, "c0")
    model.addConstr(11*x0 + 20*x1 + 19*x2 >= 59, "c1")
    model.addConstr(7*x1 + 7*x2 >= 31, "c2")
    model.addConstr(6*x0 + 7*x1 >= 23, "c3")
    model.addConstr(11*x0 + 20*x1 <= 169, "c4")
    model.addConstr(11*x0 + 20*x1 + 19*x2 <= 64, "c5")
    model.addConstr(7*x1 + 7*x2 <= 139, "c6")
    model.addConstr(6*x0 + 7*x2 <= 96, "c7")
    model.addConstr(6*x0**2 + 7*x1**2 + 7*x2**2 <= 107, "c8")
    model.addConstr(6*x0 + 7*x1 + 7*x2 <= 107, "c9")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
