
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=0, name="hours_worked_by_Paul")
    x1 = model.addVar(lb=0, name="hours_worked_by_George")
    x2 = model.addVar(lb=0, name="hours_worked_by_Bobby")

    # Objective function
    model.setObjective(-6.32*x0**2 - 6.22*x0*x1 - 6.23*x0*x2 - 5.64*x0, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(11*x0 <= 180)
    model.addConstr(6*x0 <= 141)
    model.addConstr(20*x1 <= 180)
    model.addConstr(7*x1 <= 141)
    model.addConstr(19*x2 <= 180)
    model.addConstr(7*x2 <= 141)
    model.addConstr(11*x0 + 20*x1 >= 47)
    model.addConstr(11*x0 + 20*x1 + 19*x2 >= 59)
    model.addConstr(7*x1 + 7*x2 >= 31)
    model.addConstr(6*x0 + 7*x1 >= 23)
    model.addConstr(11*x0 + 20*x1 <= 169)
    model.addConstr(11*x0 + 20*x1 + 19*x2 <= 64)
    model.addConstr(7*x1 + 7*x2 <= 139)
    model.addConstr(6*x0 + 7*x2 <= 96)
    model.addConstr(6**2*x0**2 + 7**2*x1**2 + 7**2*x2**2 <= 107)
    model.addConstr(6*x0 + 7*x1 + 7*x2 <= 107)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Paul: ", x0.varValue)
        print("Hours worked by George: ", x1.varValue)
        print("Hours worked by Bobby: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
