
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x = {}
    x[0] = m.addVar(name="hours worked by Laura")  # Laura
    x[1] = m.addVar(name="hours worked by Hank")  # Hank
    x[2] = m.addVar(name="hours worked by Peggy", vtype=gp.GRB.INTEGER)  # Peggy
    x[3] = m.addVar(name="hours worked by Mary")  # Mary


    # Set objective function
    m.setObjective(2*x[0] + 4*x[1] + 6*x[2] + 9*x[3], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(13*x[2] + 4*x[3] >= 89)
    m.addConstr(17*x[0] + 13*x[2] + 4*x[3] >= 66)
    m.addConstr(8*x[0] + 15*x[1] >= 41)
    m.addConstr(8*x[0] + 12*x[2] >= 33)
    m.addConstr(12*x[2] + 9*x[3] >= 34)
    m.addConstr(15*x[1] + 12*x[2] + 9*x[3] >= 23)
    m.addConstr(8*x[0] + 15*x[1] + 9*x[3] >= 23)
    m.addConstr(15*x[1] + 12*x[2] + 9*x[3] >= 24)
    m.addConstr(8*x[0] + 15*x[1] + 9*x[3] >= 24)
    m.addConstr(13*x[2] + 4*x[3] <= 392)
    m.addConstr(11*x[1] + 4*x[3] <= 369)
    m.addConstr(17*x[0] + 11*x[1] <= 235)
    m.addConstr(17*x[0] + 11*x[1] + 13*x[2] + 4*x[3] <= 235)
    m.addConstr(8*x[0] + 12*x[2] <= 119)
    m.addConstr(8*x[0] + 15*x[1] <= 48)
    m.addConstr(15*x[1] + 9*x[3] <= 152)
    m.addConstr(8*x[0] + 9*x[3] <= 151)
    m.addConstr(15*x[1] + 12*x[2] <= 127)
    m.addConstr(12*x[2] + 9*x[3] <= 148)
    m.addConstr(8*x[0] + 15*x[1] + 12*x[2] <= 67)
    m.addConstr(8*x[0] + 12*x[2] + 9*x[3] <= 172)
    m.addConstr(8*x[0] + 15*x[1] + 12*x[2] + 9*x[3] <= 172)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
        print(f'Obj: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
