
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name='x0', lb=0, ub=None)  # hours worked by Laura
x1 = m.addVar(name='x1', lb=0, ub=None)  # hours worked by Hank
x2 = m.addVar(name='x2', lb=0, ub=None, vtype=gurobi.GRB.INTEGER)  # hours worked by Peggy
x3 = m.addVar(name='x3', lb=0, ub=None)  # hours worked by Mary

# Objective function
m.setObjective(2*x0 + 4*x1 + 6*x2 + 9*x3, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(17*x0 <= 426)
m.addConstr(11*x1 <= 426)
m.addConstr(13*x2 <= 426)
m.addConstr(4*x3 <= 426)

m.addConstr(8*x0 <= 175)
m.addConstr(15*x1 <= 175)
m.addConstr(12*x2 <= 175)
m.addConstr(9*x3 <= 175)

m.addConstr(13*x2 + 4*x3 >= 89)
m.addConstr(17*x0 + 13*x2 + 4*x3 >= 66)
m.addConstr(8*x0 + 15*x1 >= 41)
m.addConstr(8*x0 + 12*x2 >= 33)
m.addConstr(12*x2 + 9*x3 >= 34)
m.addConstr(15*x1 + 12*x2 + 9*x3 >= 23)
m.addConstr(8*x0 + 15*x1 + 9*x3 >= 23)
m.addConstr(15*x1 + 12*x2 + 9*x3 >= 24)
m.addConstr(8*x0 + 15*x1 + 9*x3 >= 24)

m.addConstr(13*x2 + 4*x3 <= 392)
m.addConstr(11*x1 + 4*x3 <= 369)
m.addConstr(17*x0 + 11*x1 <= 235)
m.addConstr(17*x0 + 11*x1 + 13*x2 + 4*x3 <= 235)

m.addConstr(8*x0 + 12*x2 <= 119)
m.addConstr(8*x0 + 15*x1 <= 48)
m.addConstr(15*x1 + 9*x3 <= 152)
m.addConstr(8*x0 + 9*x3 <= 151)
m.addConstr(15*x1 + 12*x2 <= 127)
m.addConstr(12*x2 + 9*x3 <= 148)
m.addConstr(8*x0 + 15*x1 + 12*x2 <= 67)
m.addConstr(8*x0 + 12*x2 + 9*x3 <= 172)
m.addConstr(8*x0 + 15*x1 + 12*x2 + 9*x3 <= 172)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.Status.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Hours worked by Laura: ', x0.varValue)
    print('Hours worked by Hank: ', x1.varValue)
    print('Hours worked by Peggy: ', x2.varValue)
    print('Hours worked by Mary: ', x3.varValue)
else:
    print('No solution found')
