
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")  # hours worked by Bill
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")  # hours worked by Dale
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")  # hours worked by Jean
    x3 = m.addVar(vtype=gp.GRB.INTEGER, name="x3")  # hours worked by Bobby


    # Set objective function
    m.setObjective(9*x0**2 + x0*x1 + 6*x2*x3 + 8*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(7*x1**2 + 4*x2**2 >= 48)
    m.addConstr(4*x0**2 + 11*x3**2 >= 22)
    m.addConstr(10*x0 + 3*x1 + 10*x2 >= 31)
    m.addConstr(3*x1 + 10*x2 + 6*x3 >= 31)
    m.addConstr(10*x0 + 3*x1 + 10*x2 >= 19)
    m.addConstr(3*x1 + 10*x2 + 6*x3 >= 19)
    m.addConstr(4*x2 + 8*x3 <= 179)
    m.addConstr(8*x0**2 + 4*x2**2 <= 100)
    m.addConstr(8*x0 + 7*x1 <= 172)
    m.addConstr(7*x1**2 + 4*x2**2 <= 144)
    m.addConstr(8*x0 + 7*x1 + 4*x2 <= 84)
    m.addConstr(8*x0 + 7*x1 + 4*x2 + 8*x3 <= 84)
    m.addConstr(4*x0 + 9*x2 <= 80)
    m.addConstr(4*x0 + 9*x2 + 11*x3 <= 124)
    m.addConstr(4*x0 + 2*x1 + 9*x2 <= 193)
    m.addConstr(4*x0 + 2*x1 + 9*x2 + 11*x3 <= 193)
    m.addConstr(10*x0 + 10*x2 <= 112)
    m.addConstr(10*x2 + 6*x3 <= 92)
    m.addConstr(10*x0**2 + 6*x3**2 <= 117)
    m.addConstr(3*x1 + 10*x2 <= 130)
    m.addConstr(10*x0 + 3*x1 + 10*x2 + 6*x3 <= 130)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
