
import gurobipy as gp

# Create a new model
model = gp.Model("optimize_work_hours")

# Create variables
hank = model.addVar(vtype=gp.GRB.INTEGER, name="hank")
george = model.addVar(vtype=gp.GRB.CONTINUOUS, name="george")
peggy = model.addVar(vtype=gp.GRB.CONTINUOUS, name="peggy")
bobby = model.addVar(vtype=gp.GRB.INTEGER, name="bobby")
laura = model.addVar(vtype=gp.GRB.INTEGER, name="laura")


# Set objective function
model.setObjective(3.85*hank**2 + 3.78*hank*george + 9.52*laura**2 + 9.74*hank + 7.52*bobby, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(12*hank <= 153)
model.addConstr(12*hank <= 236)
model.addConstr(2*george <= 153)
model.addConstr(1*george <= 236)
model.addConstr(4*peggy <= 153)
model.addConstr(4*peggy <= 236)
model.addConstr(6*bobby <= 153)
model.addConstr(6*bobby <= 236)
model.addConstr(6*laura <= 153)
model.addConstr(7*laura <= 236)


#likelihood to quit index constraints
model.addConstr(2*george + 6*laura >= 15)
model.addConstr(2*george + 4*peggy + 6*laura >= 28)
model.addConstr(12*hank**2 + 2*george**2 + 4*peggy**2 >= 28)
model.addConstr(2*george**2 + 6*bobby**2 + 6*laura**2 >= 28)
model.addConstr(12*hank + 2*george + 6*laura >= 28)
model.addConstr(12*hank + 6*bobby + 6*laura >= 28)
model.addConstr(12*hank + 2*george + 6*bobby >= 28)
model.addConstr(2*george + 4*peggy + 6*laura >= 26)
model.addConstr(12*hank + 2*george + 4*peggy >= 26)
model.addConstr(2*george**2 + 6*bobby**2 + 6*laura**2 >= 26)
model.addConstr(12*hank + 2*george + 6*laura >= 26)
model.addConstr(12*hank + 6*bobby + 6*laura >= 26)
model.addConstr(12*hank**2 + 2*george**2 + 6*bobby**2 >= 26)
model.addConstr(2*george + 4*peggy + 6*laura >= 24)
model.addConstr(12*hank**2 + 2*george**2 + 4*peggy**2 >= 24)
model.addConstr(2*george + 6*bobby + 6*laura >= 24)
model.addConstr(12*hank**2 + 2*george**2 + 6*laura**2 >= 24)
model.addConstr(12*hank + 6*bobby + 6*laura >= 24)
model.addConstr(12*hank + 2*george + 6*bobby >= 24)
model.addConstr(2*george**2 + 4*peggy**2 + 6*laura**2 >= 23)
model.addConstr(12*hank + 2*george + 4*peggy >= 23)
model.addConstr(2*george + 6*bobby + 6*laura >= 23)
model.addConstr(12*hank + 2*george + 6*laura >= 23)
model.addConstr(12*hank + 6*bobby + 6*laura >= 23)
model.addConstr(12*hank + 2*george + 6*bobby >= 23)
model.addConstr(2*george + 4*peggy + 6*laura >= 25)
model.addConstr(12*hank + 2*george + 4*peggy >= 25)
model.addConstr(2*george + 6*bobby + 6*laura >= 25)
model.addConstr(12*hank + 2*george + 6*laura >= 25)
model.addConstr(12*hank + 6*bobby + 6*laura >= 25)
model.addConstr(12*hank**2 + 2*george**2 + 6*bobby**2 >= 25)
model.addConstr(2*george**2 + 4*peggy**2 + 6*laura**2 >= 22)
model.addConstr(12*hank + 2*george + 4*peggy >= 22)
model.addConstr(2*george + 6*bobby + 6*laura >= 22)
model.addConstr(12*hank**2 + 2*george**2 + 6*laura**2 >= 22)
model.addConstr(12*hank**2 + 6*bobby**2 + 6*laura**2 >= 22)
model.addConstr(12*hank**2 + 2*george**2 + 6*bobby**2 >= 22)


#organization score constraints
model.addConstr(12*hank + 7*laura >= 17)
model.addConstr(6*bobby + 7*laura >= 15)
model.addConstr(12*hank + 1*george + 7*laura >= 42)
model.addConstr(-7*hank**2 + 5*bobby**2 >= 0)
model.addConstr(6*bobby + 6*laura <= 39)
model.addConstr(2*george + 4*peggy <= 90)
model.addConstr(4*peggy + 6*laura <= 102)
model.addConstr(12*hank + 6*bobby <= 117)
model.addConstr(12*hank + 2*george <= 71)
model.addConstr(4*peggy + 6*bobby <= 72)
model.addConstr(2*george + 6*laura <= 45)
model.addConstr(12*hank + 4*peggy + 6*laura <= 84)
model.addConstr(2*george + 4*peggy + 6*laura <= 99)
model.addConstr(2*george + 4*peggy + 6*bobby <= 104)
model.addConstr(12*hank + 2*george + 4*peggy <= 96)
model.addConstr(12*hank + 2*george + 6*laura <= 135)
model.addConstr(12*hank + 2*george + 4*peggy + 6*bobby + 6*laura <= 135)
model.addConstr(4*peggy + 6*bobby <= 230)
model.addConstr(6*bobby + 7*laura <= 51)
model.addConstr(12*hank + 4*peggy + 7*laura <= 118)
model.addConstr(1*george + 4*peggy + 6*bobby <= 232)
model.addConstr(4*peggy + 6*bobby + 7*laura <= 141)
model.addConstr(12*hank + 1*george + 4*peggy + 6*bobby + 7*laura <= 141)



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print("Variable values:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

