
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(5, vtype=gp.GRB.INTEGER, name=["corn cobs", "sashimi", "cornichons", "strips of bacon", "apple pies"])


# Set objective function
m.setObjective(7.63 * x[0] + 8.79 * x[1] + 2.61 * x[2] + 7.13 * x[3] + 2.17 * x[4], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.74 * x[2] + 3.84 * x[4] >= 19)
m.addConstr(4.68 * x[1] + 3.84 * x[4] >= 26)
m.addConstr(4.68 * x[1] + 0.74 * x[2] >= 24)
m.addConstr(4.68 * x[1] + 1.55 * x[3] >= 38)
m.addConstr(4.64 * x[0] + 3.84 * x[4] >= 15)
m.addConstr(4.64 * x[0] + 4.68 * x[1] + 0.74 * x[2] >= 40)
m.addConstr(4.64 * x[0] + 4.68 * x[1] + 3.84 * x[4] >= 40)
m.addConstr(4.64 * x[0] + 1.55 * x[3] + 3.84 * x[4] >= 40)
m.addConstr(4.64 * x[0] + 0.74 * x[2] + 1.55 * x[3] >= 40)
m.addConstr(4.64 * x[0] + 4.68 * x[1] + 0.74 * x[2] >= 38)
m.addConstr(4.64 * x[0] + 4.68 * x[1] + 3.84 * x[4] >= 38)
m.addConstr(4.64 * x[0] + 1.55 * x[3] + 3.84 * x[4] >= 38)
m.addConstr(4.64 * x[0] + 0.74 * x[2] + 1.55 * x[3] >= 38)
m.addConstr(4.64 * x[0] + 4.68 * x[1] + 0.74 * x[2] >= 33)
m.addConstr(4.64 * x[0] + 4.68 * x[1] + 3.84 * x[4] >= 33)
m.addConstr(4.64 * x[0] + 1.55 * x[3] + 3.84 * x[4] >= 33)
m.addConstr(4.64 * x[0] + 0.74 * x[2] + 1.55 * x[3] >= 33)
m.addConstr(4.64 * x[0] + 4.68 * x[1] + 0.74 * x[2] >= 26)
m.addConstr(4.64 * x[0] + 4.68 * x[1] + 3.84 * x[4] >= 26)
m.addConstr(4.64 * x[0] + 1.55 * x[3] + 3.84 * x[4] >= 26)
m.addConstr(4.64 * x[0] + 0.74 * x[2] + 1.55 * x[3] >= 26)
m.addConstr(7 * x[0] - 5 * x[1] + 9 * x[2] >= 0)
m.addConstr(4.68 * x[1] + 0.74 * x[2] <= 105)
m.addConstr(4.68 * x[1] + 3.84 * x[4] <= 117)
m.addConstr(0.74 * x[2] + 1.55 * x[3] <= 206)
m.addConstr(4.68 * x[1] + 0.74 * x[2] + 3.84 * x[4] <= 85)
m.addConstr(4.68 * x[1] + 0.74 * x[2] + 1.55 * x[3] <= 183)
m.addConstr(4.64 * x[0] + 4.68 * x[1] + 3.84 * x[4] <= 151)
m.addConstr(4.64 * x[0] + 1.55 * x[3] + 3.84 * x[4] <= 96)
m.addConstr(4.64 * x[0] + 0.74 * x[2] + 1.55 * x[3] <= 223)
m.addConstr(4.64 * x[0] + 4.68 * x[1] + 0.74 * x[2] <= 147)
m.addConstr(4.68 * x[1] + 1.55 * x[3] + 3.84 * x[4] <= 167)
m.addConstr(4.64 * x[0] + 4.68 * x[1] + 0.74 * x[2] + 1.55 * x[3] + 3.84 * x[4] <= 167)
m.addConstr(4.64 * x[0] + 4.68 * x[1] + 0.74 * x[2] + 1.55 * x[3] + 3.84 * x[4] <= 232)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

