
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name='corn_cobs', vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name='sashimi', vtype=gurobi.GRB.INTEGER)
x3 = model.addVar(name='cornichons', vtype=gurobi.GRB.INTEGER)
x4 = model.addVar(name='strips_of_bacon', vtype=gurobi.GRB.INTEGER)
x5 = model.addVar(name='apple_pies', vtype=gurobi.GRB.INTEGER)

# Define the objective function
model.setObjective(7.63 * x1 + 8.79 * x2 + 2.61 * x3 + 7.13 * x4 + 2.17 * x5, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(4.64 * x1 + 4.68 * x2 + 0.74 * x3 + 1.55 * x4 + 3.84 * x5 <= 232)
model.addConstr(0.74 * x3 + 3.84 * x5 >= 19)
model.addConstr(4.68 * x2 + 3.84 * x5 >= 26)
model.addConstr(4.68 * x2 + 0.74 * x3 >= 24)
model.addConstr(4.68 * x2 + 1.55 * x4 >= 38)
model.addConstr(4.64 * x1 + 3.84 * x5 >= 15)
model.addConstr(4.64 * x1 + 4.68 * x2 + 0.74 * x3 >= 40)
model.addConstr(4.64 * x1 + 4.68 * x2 + 3.84 * x5 >= 40)
model.addConstr(4.64 * x1 + 1.55 * x4 + 3.84 * x5 >= 40)
model.addConstr(4.64 * x1 + 0.74 * x3 + 1.55 * x4 >= 40)
model.addConstr(4.64 * x1 + 4.68 * x2 + 0.74 * x3 >= 38)
model.addConstr(4.64 * x1 + 4.68 * x2 + 3.84 * x5 >= 38)
model.addConstr(4.64 * x1 + 1.55 * x4 + 3.84 * x5 >= 38)
model.addConstr(4.64 * x1 + 0.74 * x3 + 1.55 * x4 >= 38)
model.addConstr(4.64 * x1 + 4.68 * x2 + 0.74 * x3 >= 33)
model.addConstr(4.64 * x1 + 4.68 * x2 + 3.84 * x5 >= 33)
model.addConstr(4.64 * x1 + 1.55 * x4 + 3.84 * x5 >= 33)
model.addConstr(4.64 * x1 + 0.74 * x3 + 1.55 * x4 >= 33)
model.addConstr(4.64 * x1 + 4.68 * x2 + 0.74 * x3 >= 26)
model.addConstr(4.64 * x1 + 4.68 * x2 + 3.84 * x5 >= 26)
model.addConstr(4.64 * x1 + 1.55 * x4 + 3.84 * x5 >= 26)
model.addConstr(4.64 * x1 + 0.74 * x3 + 1.55 * x4 >= 26)
model.addConstr(7 * x1 - 5 * x2 + 9 * x3 >= 0)
model.addConstr(4.68 * x2 + 0.74 * x3 <= 105)
model.addConstr(4.68 * x2 + 3.84 * x5 <= 117)
model.addConstr(0.74 * x3 + 1.55 * x4 <= 206)
model.addConstr(4.68 * x2 + 0.74 * x3 + 3.84 * x5 <= 85)
model.addConstr(4.68 * x2 + 0.74 * x3 + 1.55 * x4 <= 183)
model.addConstr(4.64 * x1 + 4.68 * x2 + 3.84 * x5 <= 151)
model.addConstr(4.64 * x1 + 1.55 * x4 + 3.84 * x5 <= 96)
model.addConstr(4.64 * x1 + 0.74 * x3 + 1.55 * x4 <= 223)
model.addConstr(4.64 * x1 + 4.68 * x2 + 0.74 * x3 <= 147)
model.addConstr(4.68 * x2 + 1.55 * x4 + 3.84 * x5 <= 167)
model.addConstr(4.64 * x1 + 4.68 * x2 + 0.74 * x3 + 1.55 * x4 + 3.84 * x5 <= 167)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objVal)
    print('Corn Cobs: ', x1.varValue)
    print('Sashimi: ', x2.varValue)
    print('Cornichons: ', x3.varValue)
    print('Strips of Bacon: ', x4.varValue)
    print('Apple Pies: ', x5.varValue)
else:
    print('No optimal solution found')
