
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Paul")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Laura")


    # Set objective function
    m.setObjective(9*x0 + 2*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(14*x0 + 18*x1 >= 33, "organization_score_min")
    m.addConstr(12*x0 + 11*x1 >= 30, "work_quality_rating_min")
    m.addConstr(5*x0 - 7*x1 >= 0, "constraint_3")
    m.addConstr(14*x0 + 18*x1 <= 68, "organization_score_max")
    m.addConstr(12*x0 + 11*x1 <= 77, "work_quality_rating_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Objective Value:', m.objVal)
        print('hours worked by Paul:', x0.x)
        print('hours worked by Laura:', x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status:', m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

